<?php
function save_upload($file, $targetDir, $prefix = '') {
  if (!isset($file) || $file['error'] !== UPLOAD_ERR_OK) return null;
  $finfo = new finfo(FILEINFO_MIME_TYPE);
  $mime = $finfo->file($file['tmp_name']);
  $allowed = ['image/jpeg','image/png'];
  if (!in_array($mime, $allowed)) return null;
  $ext = $mime === 'image/png' ? '.png' : '.jpg';
  $name = $prefix . time() . '_' . bin2hex(random_bytes(6)) . $ext;
  if (!is_dir($targetDir)) mkdir($targetDir, 0755, true);
  $dest = rtrim($targetDir, '/') . '/' . $name;
  if (move_uploaded_file($file['tmp_name'], $dest)) return $name;
  return null;
}
